// copyright 2000 Eric Gunnerson
using System;
using System.Reflection;
enum MyEnum
{
    Val1,
    Val2,
    Val3
}
class MyClass
{
    MyClass() {}
    static void Process()
    {
    }
    public int DoThatThing(int i, Decimal d, string[] args)
    {
        return(55);
    }
    public int        value = 0;
    public float        log = 1.0f;
    public static int    value2 = 44;
}
class Test
{    
    public static void Main(String[] args)
    {
        // Get the names and values in the enum
        Console.WriteLine("Fields of MyEnum");
        Type t = typeof (MyEnum);
        
        // create an instance of the enum
        object en = Activator.CreateInstance(t);
        foreach (FieldInfo f in t.GetFields(BindingFlags.LookupAll))
        {
            object o = f.GetValue(en);
            Console.WriteLine("{0}={1}", f, o);
        }
        
        // Now iterate through the fields of the class
        Console.WriteLine("Fields of MyClass");
        t = typeof (MyClass);
        foreach (MemberInfo m in t.GetFields(BindingFlags.LookupAll))
        {
            Console.WriteLine("{0}", m);
        }
        
        // and iterate through the methods of the class
        Console.WriteLine("Methods of MyClass");
        foreach (MethodInfo m in t.GetMethods(BindingFlags.LookupAll))
        {
            Console.WriteLine("{0}", m);
            foreach (ParameterInfo p in m.GetParameters())
            {
                Console.WriteLine("  Param: {0} {1}",
                p.ParameterType, p.Name);
            }
        }
    }
}